VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmPnMCalibrate 
   Caption         =   "Calibrate OSCCAL"
   ClientHeight    =   4200
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   3825
   LinkTopic       =   "Form1"
   ScaleHeight     =   4200
   ScaleWidth      =   3825
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame3 
      Caption         =   "New Setting"
      Height          =   1215
      Left            =   0
      TabIndex        =   7
      Top             =   2400
      Width           =   3735
      Begin MSComctlLib.Slider Slider1 
         Height          =   375
         Left            =   120
         TabIndex        =   8
         Top             =   720
         Width           =   3375
         _ExtentX        =   5953
         _ExtentY        =   661
         _Version        =   393216
         Max             =   255
         TickStyle       =   3
         TextPosition    =   1
      End
      Begin VB.Label newvalue 
         Height          =   255
         Left            =   240
         TabIndex        =   13
         Top             =   360
         Width           =   3135
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Status"
      Height          =   615
      Left            =   0
      TabIndex        =   6
      Top             =   120
      Width           =   3735
      Begin VB.Label status 
         Height          =   255
         Left            =   120
         TabIndex        =   12
         Top             =   240
         Width           =   3495
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Current Setting"
      Height          =   1455
      Left            =   0
      TabIndex        =   2
      Top             =   840
      Width           =   3735
      Begin VB.Label instruction 
         Height          =   255
         Left            =   1440
         TabIndex        =   11
         Top             =   1080
         Width           =   2175
      End
      Begin VB.Label value 
         Height          =   255
         Left            =   1440
         TabIndex        =   10
         Top             =   720
         Width           =   1575
      End
      Begin VB.Label address 
         Height          =   255
         Left            =   1440
         TabIndex        =   9
         Top             =   360
         Width           =   1455
      End
      Begin VB.Label Label4 
         Caption         =   "Instruction"
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   1080
         Width           =   1095
      End
      Begin VB.Label Label3 
         Caption         =   "Value"
         Height          =   255
         Left            =   240
         TabIndex        =   4
         Top             =   720
         Width           =   975
      End
      Begin VB.Label Label2 
         Caption         =   "Address"
         Height          =   255
         Left            =   240
         TabIndex        =   3
         Top             =   360
         Width           =   735
      End
   End
   Begin VB.CommandButton apply 
      Caption         =   "Apply"
      Height          =   375
      Left            =   1440
      TabIndex        =   1
      Top             =   3720
      Width           =   1095
   End
   Begin VB.CommandButton exit 
      Caption         =   "Exit"
      Height          =   375
      Left            =   2640
      TabIndex        =   0
      Top             =   3720
      Width           =   1095
   End
End
Attribute VB_Name = "frmPnMCalibrate"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' TK3 programming function for new PIC types introduced by PIC n' Mix
' decoupled from the rest of TK3 to ease maintenance
' Written by Andrew Jarvis 15.08.04
'
' Revision History
' 26.03.04 Initial Revision
' 15.08.04 Final Revision
'
Option Explicit

Private oscLdec As Byte
Private oscHdec As Byte
Private Sub apply_Click()
     
    If MsgBox("Program memory will be erased, OK to continue?", _
        vbOKCancel + vbExclamation, "PnM Extension Algorithm") _
        = vbOK Then

        PnM_EnterProgramMode
        
        delay10
        PnM_Erase
        delay10
        
        PnM_RestoreOscCal PICsize - 1, oscLdec, oscHdec
        PnM_ExitProgramMode
        Update
    End If
    
End Sub
Private Sub Exit_Click()

    Unload Me
    
End Sub
Private Sub Form_Load()

    Dim actualPIC As String
    
    'read pic type
    actualPIC = PnMQueryPIC
    If actualPIC <> PICdevice Then
        MsgBox "Expected " & PICdevice & " but found " & actualPIC & ". Please replace.", _
        vbExclamation, "PnM Extension Algorithm"
        apply.Enabled = False
    Else
        status = "Found " & actualPIC
        Update
    End If

End Sub
Private Sub Update()

    Dim oscLstr As String
    Dim oscHstr As String
    
    'address of calibration memory
    address = "0x" & Hex$(PICsize - 1)
    
    'get the value
    PnM_EnterProgramMode
    PnM_ReadOscCal PICsize - 1, oscLdec, oscHdec
    PnM_ExitProgramMode

    oscLstr = Byte2Hex(oscLdec)
    oscHstr = Byte2Hex(oscHdec)
    value = "0x" & oscHstr & oscLstr
    
    'high byte should be the retlw instruction
    'its actually xx1101xx kkkkkkkk
    If (oscHdec And &H34) <> &H34 Then
        'not retlw
        instruction = "Error - retlw expected"
        oscLdec = 0
        oscHdec = &H34
        UpdateSlider
    Else
        instruction = "retlw 0x" & oscLstr
        UpdateSlider
    End If
            
End Sub
Private Function Byte2Hex(ByVal byteValue As Byte) As String
    
    Dim hexValue As String
    
    hexValue = Hex$(byteValue)
    If Len(hexValue) = 1 Then hexValue = "0" & hexValue
    Byte2Hex = hexValue
    
End Function
Private Function UpdateSlider()

    Slider1.value = oscLdec
    newvalue = "retlw 0x" & Byte2Hex(oscLdec)

End Function
Private Sub Slider1_Change()
    
    oscLdec = Slider1.value
    newvalue = "retlw 0x" & Byte2Hex(oscLdec)

End Sub
